<?php 
	require "models/rivermedia.php";
	$rivermedia = new RIVERMEDIA;
	$rivermedia->auth();
?>
<!DOCTYPE html>
<html lang="en">
<head>
<?php include_once('includes/head.php'); ?>
</head>

<body class="nav-md">
<div id="page_id">media_origins</div>
<div class="container body">
  <div class="main_container">
    <div class="col-md-3 left_col">
      <div class="left_col scroll-view">
        <div class="navbar nav_title" style="border: 0;"> <a href="admin" class="site_title">
          <?php include('includes/titlebar.php'); ?>
          </span></a> </div>
        <div class="clearfix"></div>
        
        <!-- menu profile quick info -->
        <div class="profile">
          <?php include_once('includes/profile.php'); ?>
        </div>
        <!-- /menu profile quick info --> 
        
        <br />
        
        <!-- sidebar menu -->
        <div id="sidebar-menu" class="main_menu_side hidden-print main_menu">
          <?php include_once('includes/sidebar_menu.php'); ?>
        </div>
        <!-- /sidebar menu --> 
        
        <!-- /menu footer buttons -->
        <div class="sidebar-footer hidden-small">
          <?php include_once('includes/footer_menu.php'); ?>
        </div>
        <!-- /menu footer buttons --> 
      </div>
    </div>
    
    <!-- top navigation -->
    <div class="top_nav">
      <?php include_once('includes/top_nav.php'); ?>
    </div>
    <!-- /top navigation --> 
    
    <!-- page content -->
    <div class="right_col" role="main">
      <div class="">
        <div class="page-title">
          <div class="title_left">
            <h3>Product Catalogue / Media Origins</h3>
            <h5>[Author, Speaker, Artist]</h5>
          </div>
          <div class="title_right">
            <div class="col-md-5 col-sm-5 col-xs-12 form-group pull-right top_search">
              <div class="input-group">
                <input type="text" class="form-control" placeholder="Search for...">
                <span class="input-group-btn">
                <button class="btn btn-default" type="button">Go!</button>
                </span> </div>
            </div>
          </div>
        </div>
        <div class="clearfix"></div>
        <div class="row">
          <div class="col-md-12 col-sm-12 col-xs-12">
            <div class="x_panel">
              <div class="x_title">
                <h2>Media Origin <small>[Add New]</small></h2>
                <ul id="media_addnew_toolbox" class="nav navbar-right panel_toolbox" style="text-align:center;">
                  <li id="mediaorigin_addnew_focus"><a href="javascript:void(0);" onclick="addnewFocus();"><i class="fa fa-plus" style="font-size:16pt;"></i>
                    <div>Add</div>
                    </a></li>
                  <li id="mediaorigin_list_scrollto"><a href="javascript:void(0);" onclick="var target = $('#table_list_media_origins'); if (target.length) {event.preventDefault(); $('html, body').animate({scrollTop: target.offset().top-50}, 1000);};"><i class="fa fa-pencil" style="font-size:16pt;"></i>
                    <div>Edit</div>
                    </a></li>
                </ul>
                <div class="clearfix"></div>
              </div>
              <div class="x_content"> <br />
                <form id="form_add_media_origin" data-parsley-validate class="form-horizontal form-label-left" action="javascript:void(0);">
                </form>
              </div>
            </div>
          </div>
        </div>
        <!-- end row -->
        <div class="clearfix"></div>
        <div class="row">
          <div class="col-xs-12">
            <div class="x_panel">
              <div class="x_title">
                <h2>Media Origins <small>[List]</small></h2>
                <div class="clearfix"></div>
              </div>
              <div class="x_content">
                <table class="table table-hover">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Media Origin</th>
                      <th>Description</th>
                      <th>URL Segment</th>
                      <th><div class="pull-right">Actions</div></th>
                    </tr>
                  </thead>
                  <tbody id="table_list_media_origins">
                  </tbody>
                </table>
              </div>
            </div>
          </div>
        </div>
        <!-- End row --> 
        
      </div>
    </div>
    <!-- /page content --> 
    
    <!-- footer content -->
<?php include_once('includes/footer.php'); ?>
    <!-- /footer content --> 
  </div>
</div>
<?php include_once('includes/javascript.php'); ?>
<?php include_once('includes/modals.php'); ?>
</div>
</body>
</html>