$(document).ready(function() {
	
	$('#create_account .btn-primary').bind('click', function() {
		$('#create_account').submit();
	});
	
	$('#modalPopup button, .modal-backdrop, #modalWorkArea .close, #modalWorkArea #closebutton, #confirmDelete #canceldelete, #confirmDelete .close').bind('click', function() {
		setTimeout(clearModal, 600);
	});
	
	$('[data-toggle="popover"]').popover({
		animation: true,
		placement: 'auto top'
    });
	 
	//Initialize search box
	searchBox();
	
	//Click on product thumb for more
	viewProduct();
	
	//Initialize date fields
	//$('.datepicker').datepicker('setStartDate', '1910-01-01');
	$('.datemaskfields').inputmask('yyyy-mm-dd');
	$('.phonefields').mask('000 000 0000');
	$('.item_quantities, .cart_quantity_inputs').mask('0000');
	//Create new account form
	$('#form_create_account input').attr('autocomplete', 'off');
	$('#form_create_account input[type="password"]').attr('autocomplete', 'address-level4');
	$('#form_create_account').attr('autocomplete', 'off');
	
	//Navigation
	$('#main_navigation>li>a').bind('click', function() {
		var thisOption = $(this).html();
		switch(thisOption) {
			case 'Search':
				searchFormPosition = parseInt($('#searchform').css('margin-top'));
				if (searchFormPosition === 0) {
					$('#searchform').animate({'margin-top':'-70px'}, 400);
				}
				else {
					$('#searchform').animate({'margin-top':'0'}, 400);
				};
				$('#search_count').html('');
				$('#searchform input').focus().val('');
		};
	});
	$('#main_navigation>li>ul>li>a').bind('click', function() {
		var thisOption = $(this).html();
		switch(thisOption) {
			case '<i class="fa fa-list" aria-hidden="true"></i> Create new account':
				createAccountForm();
				break;
			case '<i class="fa fa-sign-in" aria-hidden="true"></i> Sign in':
				signIn();
				break;
			case '<i class="fa fa-sign-out" aria-hidden="true"></i> Sign out':
				signOut();
				break;
		};
	});

	//Add to cart
	$('.product_tiles .add_to_cart').bind('click', function() {
		var blockId = $(this).parent().parent().parent().parent().attr('id');
		var blockType = blockId[0];
		var productId = blockId.split('_')[1];
		var productPrefix = blockId.split('_')[0];
		$('#'+productPrefix+'_'+productId+' .popover .popover-content').html(popoverContent.replace(/PRODUCT-ID/g, productId).replace(/quantity_/g, blockType+'quantity_'));
		var badgeQuantity;
		if (parseInt($('#'+productPrefix+'_'+productId+' .badge').length) > 0) {
			if (!(isNaN(parseInt($('#'+productPrefix+'_'+productId+' .badge').html()))) && parseInt($('#'+productPrefix+'_'+productId+' .badge').html()) > 0) {
				$('#'+productPrefix+'_'+productId+' .popover .button_labels').html($('#'+productPrefix+'_'+productId+' .popover .button_labels').html().replace('BUTTON-LABEL', 'UPDATE'));
				badgeQuantity = $('#'+productPrefix+'_'+productId+' .badge').html();
				$('#'+blockType+'quantity_'+productId).val(badgeQuantity);
			}
			else {
				$('#'+productPrefix+'_'+productId+' .popover .button_labels').html($('#'+productPrefix+'_'+productId+' .popover .button_labels').html().replace('BUTTON-LABEL', 'ADD'));
			};
		}
		else {
			$('#'+productPrefix+'_'+productId+' .popover .button_labels').html($('#'+productPrefix+'_'+productId+' .popover .button_labels').html().replace('BUTTON-LABEL', 'ADD'));
		};
		$('.popover_head a').bind('click', function() {
			$('#'+productPrefix+'_'+productId+' .add_to_cart').click();
		});
		$('#'+productPrefix+'_'+productId+' .popover_add_to_cart').bind('click', function() {
			var quantity = $('#'+blockType+'quantity_'+productId).val();
			addToCart(productId, quantity, blockType);
		});
		setTimeout(function() {
			$('#'+blockType+'quantity_'+productId).focus();
		}, 200);
	});

	//Update cart item
	$('#cart_table .btn').bind('click', function() {
		var productId = $(this).attr('id').split('_')[1];
		var quantity = $('#ct_'+productId).val();
		updateCartItem(productId, quantity, 'cart');
	});
	
	//Delete from cart (item list view)
	$('.product_tiles .remove_from_cart').unbind();
	$('.product_tiles .remove_from_cart').each(function() {
		var productId = $(this).parent().parent().parent().parent().attr('id').split('_')[1];
		var blockType = $(this).parent().parent().parent().parent().attr('id')[0];
		$(this).bind('click', function() {
			deleteFromCart(productId, 'tile', blockType)
		});
	});
	
	//Delete from cart (cart view)
	$('#cart_table i').bind('click', function() {
		var productId = $(this).attr('id').split('_')[1];
		deleteFromCart(productId, 'cart', '');
	});
	
	//Checkout button
	$('#checkout_button').bind('click', function() {
		checkOutButton();
	});
	
	//EFT payment button
	$('#btn_eft').bind('click', function() {
		eftPay();	
	});
	
	$('#invoice_table tr').bind('click', function() {
		var orderId = $(this).attr('id').replace('inv_', '');
		viewSelectedInvoice(orderId);	
	});
	
	//Category options
	$('.cat_col li a, .tab-pane a').bind('click', function() {
		var values = $(this).attr('data-category-type');
		var type = values.split('__')[0];
		var name = values.split('__')[1];
		categorySearch(type, name);
	});
	
	//Contact form
	if ($('#page_name').html() === 'contact') {
		$('#mask').fadeIn(300);
		$.ajax({
			type: 'POST',
			url: 'contact_form',
			success: function(data) {
				$('#mask').fadeOut(300);
				$('#ajax_contact_form').html(data);
				contactForm();
			}
		});
	};
	

});